setwd("D:/Desktop")
library(ggplot2)
library(ggpubr)
library(cowplot)
data <- read.table('data.txt',header = T)
test <- data.frame(t(data)[c(-1),])
test$Vero_Control_6h <- as.numeric(test$X1)+as.numeric(test$X2)
test$Vero_Control_12h <- as.numeric(test$X3)+as.numeric(test$X4)
test$Vero_SARS_Cov_2_6h <- as.numeric(test$X5)+as.numeric(test$X6)
test$Vero_SARS_Cov_2_12h <- as.numeric(test$X7)+as.numeric(test$X8)
temp <- test[,c(9,10,11,12)]
temp <- t(temp)
remove(test)
test <- data.frame(temp)
test$unannotated <- test$UMG+test$UUG-test$vsRNA
test$other <- test$clean_reads-test$miRNA-test$rRNA-test$tRNA-test$piRNA-test$vsRNA-test$unannotated
test$percentage1 <- test$miRNA/test$clean_reads
test$percentage2 <- test$rRNA/test$clean_reads
test$percentage3 <- test$tRNA/test$clean_reads
test$percentage4 <- test$piRNA/test$clean_reads
test$percentage5 <- test$vsRNA/test$clean_reads
test$percentage6 <- test$unannotated/test$clean_reads
test$percentage7 <- test$other/test$clean_reads
remove(temp)
temp <- data.frame(test[,c(13,14,15,16,17,18,19)])
colnames(temp) <- c("amiRNA","crRNA","etRNA","gpiRNA","fvsRNA","bunannotated","dother")
rownames(temp) <- c("Vero_Control_6h","Vero_Control_12h","Vero_SARS-Cov-2_6h","Vero_SARS-Cov-2_12h")
result <- as.data.frame(t(temp))
result$type <- rownames(result)

yanse <- c("#E0476A","#F4C324","#48B892","#77A0D2","#C5D94A","#0B318F","#868687")
mylabe <- paste(round(result$`Vero_Control_6h`*100,2),'%',sep='')
#p1 <- ggpie(result,'Vero_Control_6h',fill='type',legend="right",label = mylabe,lab.pos = 'out',lab.font = c(4,'white'),palette = 'jco')
p1 <- ggpie(result,'Vero_Control_6h',fill='type',color="NA",legend="right",label = mylabe,lab.pos = 'out',lab.font = c(4,'white'),palette = yanse)

mylabe <- paste(round(result$`Vero_Control_12h`*100,2),'%',sep='')
#mylabe <- paste(result$type,'(',round(result$`Vero_Control_12h`*100,2),'%',')',sep='')
#p2 <- ggpie(result,'Vero_Control_12h',fill='type',legend="right",label = mylabe,lab.pos = 'out',lab.font = c(4,'white'),palette = 'jco')
p2 <- ggpie(result,'Vero_Control_12h',fill='type',color="NA",legend="right",label = mylabe,lab.pos = 'out',lab.font = c(4,'white'),palette = yanse)

mylabe <- paste(round(result$`Vero_SARS-Cov-2_6h`*100,2),'%',sep='')
#mylabe <- paste(result$type,'(',round(result$`Vero_SARS-Cov-2_6h`*100,2),'%',')',sep='')
#p3 <- ggpie(result,'Vero_SARS-Cov-2_6h',fill='type',legend="right",label = mylabe,lab.pos = 'out',lab.font = c(4,'white'),palette = 'jco')
p3 <- ggpie(result,'Vero_SARS-Cov-2_6h',fill='type',color="NA",legend="right",label = mylabe,lab.pos = 'out',lab.font = c(4,'white'),palette = yanse)

mylabe <- paste(round(result$`Vero_SARS-Cov-2_12h`*100,2),'%',sep='')
#mylabe <- paste(result$type,'(',round(result$`Vero_SARS-Cov-2_12h`*100,2),'%',')',sep='')
#p4 <- ggpie(result,'Vero_SARS-Cov-2_12h',fill='type',legend="right",label = mylabe,lab.pos = 'out',lab.font = c(4,'white'),palette = 'jco')
p4 <- ggpie(result,'Vero_SARS-Cov-2_12h',fill='type',color="NA",legend="right",label = mylabe,lab.pos = 'out',lab.font = c(4,'white'),palette = yanse)
c <- plot_grid(p1,p3,p2,p4,nrow = 2,ncol = 2,align = "hv")

pdf("pie-new.pdf",width=8,height = 8)
c
dev.off()
